/*
 * One structure allocated per active
 * process. It contains all data needed
 * about the process.
 */
struct	proc {
	char	p_stat;
	char	p_flag;
	char	p_pri;		/* priority, negative is high */
	char	p_pid;		/* process id = process number */
	struct msgblk *p_msgbp;	/* linked list of messages */
	long	p_sig;		/* signals pending to this process */
	long	p_trcmask;	/* signals being traced */
	long	p_cursig;
	caddr_t	p_addr;		/* start address of process */
	long	p_size;		/* size of process (bytes) */
	caddr_t	p_uarea;	/* start address of U area */
	long	p_usize;	/* size of U area (bytes) */
	caddr_t p_wchan;	/* event process is awaiting */
	struct user *p_userp;	/* pointer to the user structure */
	struct text *p_textp;	/* pointer to text structure */
	struct proc *p_link;	/* linked list of running processes */
	struct proc *p_clink;	/* linked list of clock processes */
	struct proc *p_trace;	/* process pointer for tracing */
	short	p_clktim;	/* time to alarm clock signal */
	short	p_code;		/* more signal info */
	char	p_ppid;		/* process id of parent */
	char	p_msgcnt;	/* number of received messages */
};

/* stat codes */
#define	SSLEEP	1		/* awaiting an event */
#define	SRUN	3		/* running */
#define	SIDL	4		/* intermediate state in process creation */
#define	SZOMB	5		/* intermediate state in process termination */
#define	SSTOP	6		/* process being traced */

/* flag codes */
#define SALARM	01		/* process is in the clock que */
#define SASIG	02		/* send a signal on alarm, otherwise wakeup */
#define	SSEXEC	04		/* stop on exec */
#define	STRC	020		/* process is being traced */
#define	SWTED	040		/* another tracing flag */
#define	STIMO	0200		/* timing out during sleep */
